-- DSS queries
-- Oracle version

set echo on

-- dss_select_01
-- uses: tenpct
-- might use index on: tenpct.t_key
-- returns 1 row, answer is "999999"

select count(t_key)
	from tenpct
	where t_key <> 0;

----------

-- dss_select_02
-- uses: uniques
-- might use index on: uniques.u_key
-- returns 1 row, answer is "0"

select min(u_key)
	from uniques;

----------

-- dss_select_03
-- uses: hundred
-- might use index on: hundred.h_key, hundred.h_name
-- returns 100 rows

select max(h_key)
	from hundred
	group by h_name
	order by 1;

----------

-- dss_select_04
-- uses: tenpct
-- might use index on: tenpct.t_name, tenpct.t_int, tenpct.t_signed, tenpct.t_float, tenpct.t_double, tenpct.t_decim
-- returns 1 row, answer is "0"

select count(t_key)
	from tenpct
	where t_name = 'THE+ASAP+BENCHMARKS+'
		and t_int <= 100000000
		and t_signed between 1 and 99999999
		and not (t_float between -450000000 and 450000000)
		and t_double > 600000000
		and t_decim < -600000000;

----------

-- dss_select_05
-- uses: updates, hundred
-- might use index on: updates.p_key, updates.p_decim, hundred.h_key
-- returns 1 row, answer is "995000995"

select avg(updates.p_decim)
	from updates
	where updates.p_key in
		(select updates.p_key
		from updates, hundred
		where hundred.h_key = updates.p_key
		and updates.p_decim > 990000000);

----------

-- dss_select_06
-- uses: reportview
-- might use index on: reportview.r_decim (updates.p_decim), reportview.r_code (hundred.h_code), reportview.r_int (hundred.h_int) (last two are unlikely, a simple row scan is a better choice)
-- returns 10,000 rows

select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name)
	from reportview
	where r_decim > 980000000
	group by r_code, r_int
	order by 1;

----------

-- dss_select_07
-- uses: updates, hundred
-- might use index on: updates.p_key, updates.p_decim, hundred.h_key, hundred.h_code, hundred.h_int
-- returns 10,000 rows

select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(hundred.h_date), max(hundred.h_date), count(distinct hundred.h_name), count(hundred.h_name)
	from updates, hundred
	where updates.p_key = hundred.h_key
		and updates.p_decim > 980000000
	group by hundred.h_code, hundred.h_int
	order by 1;

----------

-- dss_select_08
-- uses: reportview
-- might use index on: reportview.r_decim (updates.p_decim)
-- returns 1 row

select min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name), count(r_code), count(r_int)
	from reportview
	where r_decim > 900000000;

----------

-- dss_select_09
-- uses: updates, hundred
-- might use index on: updates.p_key, updates.p_decim, hundred.h_key
-- returns 1 row

select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int)
	from updates, hundred 
	where updates.p_key = hundred.h_key 
		and updates.p_decim > 900000000;

----------

-- dss_select_10
-- uses: hundred
-- might use index on: hundred.h_name
-- returns 100 rows, all counts are "10000"

select h_name, count(h_name)
	from hundred
	group by h_name
	order by 2;

----------

-- dss_select_11
-- uses: hundred
-- might use index on: hundred.h_name
-- returns 100 rows

select h_name
	from hundred
	group by h_name
	having count(h_name) > 10
	order by h_name;

----------

-- dss_select_12
-- uses: hunthou
-- might use index on: hunthou.h_float (will need to tablescan anyway)
-- returns 1 row, answer is "50000"

select count(h_name)
	from hunthou
	where h_float > 
		(select avg(h_float) from hunthou);

----------

-- dss_select_13
-- uses: threemill
-- might use index on: threemill.t_signed
-- select 25% of the table
-- uses: threemill
-- might use index on: threemill.t_signed
-- returns 1 row, answer is "750000"

select count(t_key)
	from threemill
	where t_signed <= -250000000;

exit
